<?php
/**
 * The Template for displaying all single posts.
 *
 * @package dokan
 * @package dokan - 2014 1.0
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $post;

$seller_id = $post->post_author;

dokan_get_template_part( 'prk-store-avatar', '', array(
    'seller_id'      => $seller_id,
  ) );

return;


$store_custom_map_location = $store_info['seller_custom_map'];
$custom_dokan_options = get_option('dokan_general');
$custom_map_api_key = $custom_dokan_options['gmap_api_key']; // pk.eyJ1Ijoic2luYWJvcm9tYW5kIiwiYSI6ImNqbXlxa2JjNzBxcW8zd3RjMGp3ZjZnbnMifQ.wbUeFynkdiDxuYkc0OShYQ

?>
<div class="container" style="margin-top:20px;">

    <div class="prk_store_wrapper">

        <div class="store_aside">
            <div class="store_aside_box">
                <?php
                $store_author_id = get_post_field( 'post_author',get_the_ID());
                $store_url = dokan_get_store_url( $store_author_id );
                $store_avatar =  get_avatar( $store_author_id , 120 );
                $store_rating  = dokan_get_seller_rating( $store_author_id ); // dokan_get_readable_seller_rating
                $store_rating__rate_count = $store_rating['rating'] ? $store_rating['rating'] : 0;
                $store_rating__user_rated = $store_rating['count'];
                ?>
                <div class="store_header"><?php echo $store_avatar; ?></div>
                <h1 class="store_name"><a href="<?php echo $store_url; ?>"><?php echo $store_info['store_name']; ?></a></h1>
                <div class="store_reg_date">
                    <span><?php _e('زمان عضویت در', 'newkala'); ?> <?php bloginfo('name'); ?> : </span><span><?php echo date_i18n( "j F Y", strtotime( $store_user->data->user_registered ) ); ?></span>

                </div>
                <div class="store_vote">
                    <style>
                        .woocommerce .star-rating {
                            float: left;
                            overflow: hidden;
                            position: relative;
                            height: 1em;
                            line-height: 1;
                            font-size: 1em;
                            width: 5.4em;
                            font-family: star;
                        }
                        .woocommerce .star-rating::before {
                            content: '\73\73\73\73\73';
                            color: #d3ced2;
                            float: right;
                            top: 0;
                            right: 0;
                        }
                        .woocommerce .star-rating span {
                            overflow: hidden;
                            float: right;
                            top: 0;
                            right: 0;
                            position: absolute;
                            padding-top: 1.5em;
                        }
                        .woocommerce .star-rating span::before {
                            content: '\53\53\53\53\53';
                            top: 0;
                            position: absolute;
                            right: 0;
                        }
                    </style>
                    <div class="store_vote_stars">
                        <div class="dokan-rating woocommerce">
                            <div itemprop="reviewRating" itemscope="" itemtype="http://schema.org/Rating" class="star-rating" title="امتیاز  5 از 5">
                                <?php
                                $store_score = ($store_rating__rate_count * 100) / 5;
                                echo '<span style="width:'.$store_score.'%"><strong itemprop="ratingValue" class="rating">'.$store_score.'</strong> '.__( 'از 5', 'woocommerce' ).'</span>';
                                ?>

                            </div>
                        </div>
                        <div class="store_vote_stars_details"><span><?php echo $store_rating__rate_count; ?> <?php echo __('رضایت خرید', 'newkala'); ?></span><span>|</span><span>(<?php echo $store_rating__user_rated; ?>) <?php echo __('رای', 'newkala'); ?></span></div>
                    </div>

                </div>
                <div class="store_share_link">

                        <?php
                        $store_url = preg_replace('{/$}', '', $store_url);

                        ?>
						<input type="text" readonly value="<?php echo $store_url; ?>" />


                </div>
            </div>
        </div>

        <style>
            .store_product_tab {
                border : 1px solid #eee;
                padding: 15px;
                min-height: 315px !important;
            }
            #prk_store_details_content .store_details_content_small_infos {
                border-top: none !important;
            }
        </style>

        <div class="store_tabs_wrapper">
            <div id="prk_store_details_content" class="store_content store_product_tab store_active">
                <div class="store_details_content_map">
                    <?php //if($store_custom_map_location):
                     if(0): ?>
                        <div id="mapid" style="height: 350px;width: 100%"></div>
                        <script>
                            var mymap = L.map('mapid').setView([<?php echo $store_custom_map_location; ?>],15);
                            L.tileLayer('http://{s}.tile.osm.org/{z}/{x}/{y}.png?access_token=<?php echo $custom_map_api_key; ?>', {
                                maxZoom: 50,
                                attribution: '', // custom html
                                id: 'mapbox.streets'
                            }).addTo(mymap);
                            L.marker([<?php echo $store_custom_map_location; ?>]).addTo(mymap).bindPopup("<div style='text-align:right;'><b><?php echo $store_info['store_name']; ?></b></div>").openPopup();
                        </script>
                    <?php else: ?>
                        <div class="store_no_map">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Capa_1" x="0px" y="0px" viewBox="0 0 54 54" style="enable-background:new 0 0 54 54;" xml:space="preserve" width="80px" height="80px">
    <g>
        <path d="M53.516,1.143c-0.3-0.182-0.674-0.19-0.983-0.027L36,9.869L19.468,1.116c-0.013-0.007-0.028-0.009-0.041-0.015   c-0.048-0.023-0.097-0.04-0.147-0.055c-0.028-0.008-0.055-0.017-0.083-0.023c-0.055-0.011-0.111-0.015-0.168-0.017   c-0.025-0.001-0.05-0.004-0.076-0.003c-0.054,0.003-0.107,0.013-0.16,0.025c-0.03,0.006-0.06,0.01-0.089,0.019   c-0.007,0.002-0.014,0.002-0.02,0.004l-18,6C0.275,7.187,0,7.569,0,8v43c0,0.321,0.154,0.623,0.416,0.812   C0.588,51.935,0.793,52,1,52c0.106,0,0.213-0.017,0.316-0.052l17.646-5.882l16.657,6.859c0.014,0.006,0.03,0.004,0.044,0.009   C35.773,52.973,35.885,53,36,53c0.09,0,0.179-0.015,0.266-0.039c0.028-0.008,0.054-0.021,0.082-0.031   c0.04-0.015,0.082-0.026,0.12-0.046l17-9C53.795,43.711,54,43.37,54,43V2C54,1.649,53.816,1.324,53.516,1.143z M2,8.721l16-5.333   v26.992c-0.43,0.078-0.854,0.166-1.264,0.274c-0.534,0.142-0.852,0.689-0.71,1.223c0.119,0.448,0.523,0.744,0.966,0.744   c0.084,0,0.171-0.011,0.257-0.033c0.24-0.064,0.502-0.096,0.751-0.148v11.84L2,49.612V8.721z M20,32.16   c0.321-0.025,0.632-0.066,0.961-0.073c0.552-0.012,0.99-0.469,0.979-1.021c-0.012-0.545-0.457-0.979-1-0.979   c-0.007,0-0.015,0-0.022,0c-0.31,0.007-0.615,0.024-0.918,0.045V3.661l15,7.941v21.194c-0.714-0.031-1.44-0.115-2.201-0.262   c-0.544-0.107-1.067,0.249-1.172,0.791s0.25,1.067,0.792,1.172c0.886,0.172,1.746,0.256,2.582,0.289v15.721L20,44.33V32.16z    M52,42.397l-15,7.941v-15.66c0.372-0.169,0.62-0.549,0.587-0.98c-0.029-0.374-0.269-0.674-0.587-0.821V11.602l15-7.941V42.397z" fill="#a4a4a4"/>
        <path d="M11,9c-2.757,0-5,2.243-5,5c0,2.415,1.721,4.434,4,4.899V21c0,0.553,0.448,1,1,1s1-0.447,1-1v-2.101   c2.279-0.465,4-2.484,4-4.899C16,11.243,13.757,9,11,9z M11,17c-1.654,0-3-1.346-3-3s1.346-3,3-3s3,1.346,3,3S12.654,17,11,17z" fill="#a4a4a4"/>
        <path d="M45.07,27.673c0.12,0.047,0.243,0.068,0.364,0.068c0.4,0,0.777-0.241,0.932-0.636c0.47-1.199,0.847-2.553,1.123-4.024   c0.102-0.542-0.256-1.064-0.799-1.167c-0.546-0.09-1.065,0.257-1.167,0.8c-0.252,1.348-0.595,2.58-1.019,3.663   C44.303,26.89,44.556,27.471,45.07,27.673z" fill="#a4a4a4"/>
        <path d="M12.805,32.342c-1.207,0.757-2.295,1.705-3.235,2.82c-0.356,0.422-0.302,1.053,0.12,1.409   c0.188,0.158,0.417,0.235,0.644,0.235c0.285,0,0.567-0.121,0.765-0.355c0.806-0.956,1.737-1.769,2.768-2.414   c0.468-0.294,0.609-0.911,0.316-1.379C13.89,32.19,13.272,32.048,12.805,32.342z" fill="#a4a4a4"/>
        <path d="M8.627,38.276c-0.502-0.23-1.096-0.013-1.327,0.489c-1.026,2.226-1.28,4.023-1.291,4.099   c-0.075,0.547,0.307,1.05,0.854,1.125c0.046,0.007,0.093,0.01,0.138,0.01c0.491,0,0.919-0.362,0.99-0.861   c0.002-0.016,0.231-1.597,1.125-3.534C9.347,39.101,9.128,38.508,8.627,38.276z" fill="#a4a4a4"/>
        <path d="M40.423,33.729c0.153,0,0.309-0.035,0.454-0.109c1.292-0.661,2.431-1.599,3.384-2.786c0.346-0.431,0.277-1.061-0.154-1.406   c-0.43-0.343-1.06-0.276-1.406,0.154c-0.776,0.967-1.696,1.726-2.735,2.257c-0.492,0.252-0.687,0.854-0.435,1.346   C39.709,33.53,40.06,33.729,40.423,33.729z" fill="#a4a4a4"/>
        <path d="M29.17,31.432c-0.441-0.185-0.699-0.313-0.716-0.322c-0.065-0.033-0.134-0.06-0.205-0.078   c-1.083-0.278-2.15-0.498-3.173-0.654c-0.545-0.086-1.056,0.291-1.14,0.837c-0.083,0.546,0.292,1.057,0.838,1.14   c0.926,0.142,1.893,0.34,2.877,0.59c0.134,0.064,0.39,0.185,0.748,0.334c0.126,0.053,0.257,0.077,0.385,0.077   c0.391,0,0.763-0.23,0.923-0.614C29.92,32.23,29.68,31.644,29.17,31.432z" fill="#a4a4a4"/>
        <path d="M46.923,19.931c0.022,0.001,0.043,0.002,0.065,0.002c0.523,0,0.963-0.406,0.997-0.937c0.062-0.961,0.093-1.978,0.093-3.02   c0-0.347-0.003-0.699-0.01-1.058c-0.01-0.553-0.49-0.973-1.018-0.982c-0.552,0.01-0.992,0.466-0.982,1.018   c0.006,0.347,0.01,0.688,0.01,1.022c0,1-0.03,1.973-0.089,2.893C45.954,19.42,46.372,19.895,46.923,19.931z" fill="#a4a4a4"/>
        <path d="M8.293,28.707C8.488,28.902,8.744,29,9,29s0.512-0.098,0.707-0.293L11,27.414l1.293,1.293C12.488,28.902,12.744,29,13,29   s0.512-0.098,0.707-0.293c0.391-0.391,0.391-1.023,0-1.414L12.414,26l1.293-1.293c0.391-0.391,0.391-1.023,0-1.414   s-1.023-0.391-1.414,0L11,24.586l-1.293-1.293c-0.391-0.391-1.023-0.391-1.414,0s-0.391,1.023,0,1.414L9.586,26l-1.293,1.293   C7.902,27.683,7.902,28.316,8.293,28.707z" fill="#a4a4a4"/>
    </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
                                <g>
                                </g>
    </svg>
                            <span><?php echo __('این فروشنده ، موقعیت مکانی خود را برروی نقشه مشخص نکرده است.', 'newkala'); ?></span>
                        </div>
                    <?php endif; ?>
                </div>

            </div>
        </div>

    </div>

</div>
