<?php
class product_carosel_Widget extends \Elementor\Widget_Base {


	public function get_name() {
		return 'product-carosel';
	}

	public function get_title() {
		return 'کاروسل محصولات';
	}

	public function get_icon() {
		return 'eicon-product-images';
	}

	public function get_categories() {
		return [ 'prk-category' ];
	}

	protected function register_controls() {
		$this->start_controls_section(
			'text',
			[
				'label' => 'کاروسل محصولات',
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,

			]
		);

		$this->add_control(
			'title_section',
			[
				'label' => 'عنوان',
				'type' => \Elementor\Controls_Manager::TEXT,
				'input_type' => 'text',
				'placeholder' => 'عنوان',
				'default' => 'عنوان',
			]
		);
		$this->add_control(
				 'title_border',
				 [
						'label' => __( 'نمایش زیر عنوان', 'parskala' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'default' => 'yes',

				 ]
			);
		$this->add_control(
			'title_icon',
			[
				'label' => ' ایکن <a href="https://materialdesignicons.com" target="_blank">دریافت ایکن از این سایت</a>',
				'type' => \Elementor\Controls_Manager::TEXT,
				'input_type' => 'text',
				'placeholder' => 'ایکن',
			]
		);
$options = array();



$categories =  $categories = get_categories(array('taxonomy'=> 'product_cat'));
foreach ( $categories as $key => $category ) {
    $options[$category->term_id] = $category->name;

}

		    // حلقه دسته بندی های محصولات
				$options = array();
				$args = array(
				'hide_empty' => false,
				);
				$categories =  $categories = get_categories(array('taxonomy'=> 'product_cat'));
				foreach ( $categories as $key => $category ) {$options[$category->term_id] = $category->name;}

				$prod_cata = array();
				$categories = get_terms("product_cat");
				if ( !empty( $categories ) && !is_wp_error( $categories ) ){
					foreach ( $categories as $category ) {
						$prod_cata[ $category->term_id ] = $category->name;
					}
				}


					$prod_taga = array();
					$tags = get_terms("product_tag");
					if ( !empty( $tags ) && !is_wp_error( $tags ) ){
						foreach ( $tags as $tag ) {
							$prod_taga[ $tag->term_id ] = $tag->name;
						}
					}



					$prod_brand = array();
					$brands = get_terms("brand");
					if ( !empty( $brands ) && !is_wp_error( $brands ) ){
						foreach ( $brands as $brand ) {
							$prod_brand[ $brand->term_id ] = $brand->name;
						}
					}


					$this->add_control(
						'prod_sort',
						[
							'label' => __( 'مرتب سازی محصولات', 'parskala' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'default' => 'latest',
							'options' => [
								'latest'  => __( 'آخرین محصولات', 'parskala' ),
								'random' => __( 'محصولات تصادفی', 'parskala' ),
								'viewed' => __( 'پربازدید ترین محصولات', 'parskala' ),
								'saled' => __( 'محصولات پر فروش', 'parskala' ),
								'price-desc'  => __( 'قیمت از نزولی', 'parskala' ),
								'price-asc'  => __( 'قیمت از صعودی', 'parskala' ),
								'coming_soon' => __( 'محصولات به زودی', 'parskala' ),
								'discounted' => __( 'محصولات تخفیف خورده', 'parskala' ),
								'rand_discounted' => __( 'محصولات تخفیف خورده تصادفی', 'parskala' ),
								'special' => __( 'محصولات شگفت انگیز', 'parskala' ),
								'rand_special' => __( 'محصولات شگفت انگیز تصادفی', 'parskala' ),
								'menu_order' => __( 'برطبق عنوان', 'parskala' ),
							],
						]
					);

					$this->add_control(
						'out_prod',
						[
							'label' => __( 'نمایش محصولات موجود در انبار', 'parskala' ),
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'label_on' => __( 'روشن', 'parskala' ),
							'label_off' => __( 'خاموش', 'parskala' ),
							'return_value' => 'yes',
							'default' => 'no',
						]
					);
					$this->add_control(
						'prod_filter',
						[
							'label' => __( 'فیلتر محصول', 'parskala' ),
							'type' => \Elementor\Controls_Manager::SELECT,
							'default' => 'category',
							'options' => [
								'category'  => __( 'دسته محصوالت', 'parskala' ),
								'tag' => __( 'برچسب محصولات', 'parskala' ),
								'brand' => __( 'برند محصولات', 'parskala' ),
								'pro_id' => __( 'انتخاب دستی محصولات', 'parskala' ),
							],
						]
					);

					$this->add_control( //Header
						'header_enabled',
						[
							'label' => esc_html__('Show Header', 'wooslider-bymdez'),
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'label_on' => esc_html__( 'Active', 'wooslider-bymdez' ),
							'label_off' => esc_html__( 'Inactive', 'wooslider-bymdez' ),
							'return_value' => 'yes',
							'default' => 'yes',
						]
					);

					$this->add_control(
						'product_cat',
						[
							'label' => __( 'دسته بندی محصولات', 'parskala' ),
							'description' => __( 'برچسب های خالی (بدون محصول) نمایش داده نمی شوند', 'parskala' ),
							'type' => \Elementor\Controls_Manager::SELECT2,
							'multiple' => true,
							'options' => $prod_cata,
							'condition' => [
													'prod_filter' => 'category',
											],
						]
					);
					$this->add_control(
						'product_tag',
						[
							'label' => __( 'فیلتر بر اساس تگ', 'parskala' ),
							'description' => __( 'برچسب های خالی (بدون محصول) نمایش داده نمی شوند', 'parskala' ),
							'label_block' => true,
							'type' => \Elementor\Controls_Manager::TEXT,
							'placeholder' => __( 'Tag(s) ID', 'parskala' ),
							'condition' => [
								'prod_filter' => 'tag',
							],
						]
					);
					$this->add_control(
						'product_brand',
						[
							'label' => __( 'فیلتر بر اساس برند', 'parskala' ),
							'description' => __( 'فیلتر و نمایش محصول بر اساس برند', 'parskala' ),
							'type' => \Elementor\Controls_Manager::SELECT2,
							'multiple' => true,
							'options' => $prod_brand,
							'condition' => [
								'prod_filter' => 'brand',
							],
						]
					);
					$this->add_control(
						'product_id',
						[
							'label' => __( 'شناسه محصولات', 'parskala' ),
							'description' => __( 'ایدی محصولات رو با , جدا کنید مثلا: 10,20,310', 'parskala' ),
							'label_block' => true,
							'type' => \Elementor\Controls_Manager::TEXT,
							'placeholder' => __( 'آیدی محصول', 'parskala' ),
							'condition' => [
								'prod_filter' => 'pro_id',
							],
						]
					);
				$this->add_control(
					'ptotalcount',
					[
						'label' => __( 'تعداد محصولات', 'parskala' ),
						'type' => \Elementor\Controls_Manager::NUMBER,
						'min' => 1,
						'max' => 200,
						'step' => 1,
						'default' => 8,
					]
				);
$this->add_control(
    'category_url',
    [
        'label' => __( 'لینک دسته', 'plugin-domain' ),
        'type' => \Elementor\Controls_Manager::URL,
        'multiple' => true,
    ]
  );
	$this->add_control(
	    'category_url_viewall',
	    [
	        'label' => __( 'لینک مشاهده همه', 'plugin-domain' ),
	        'type' => \Elementor\Controls_Manager::URL,
	        'multiple' => true,

	    ]
	  );

					$this->add_control(
							 'showـbtnـcart',
							 [
									'label' => 'نمایش دکمه افزودن به سبد خرید',
									'type' => \Elementor\Controls_Manager::SWITCHER,
									'default' => 'false',

							 ]
						);
								$this->add_control(
										'btnـcart_style',
										[
											'label' => esc_html__( 'استایل دکمه', 'plugin-name' ),
											'type' => \Elementor\Controls_Manager::SELECT,
											'default' => 'icon',
													'options' => [
														'icon'  => esc_html__( 'ایکن', 'plugin-name' ),
														'text' => esc_html__( 'متن', 'plugin-name' ),
											],
					           ]
		               );

					   $this->add_control(
						'prk_show_unavailable_text',
						[
							'label' => 'نمایش لیبل ناموجود',
							'description' => 'نمایش لیبل ناموجود برای محصولات ناموجود',
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'label_on' => __( 'بله', 'your-plugin' ),
							'label_off' => __( 'خیر', 'your-plugin' ),
							'return_value' => 'true',
							'default' => 'true',
						]
					);
				
					$this->add_control(
						'prk_unavailable_text',
						[
							'label' => __( 'متن لیبل ناموجود', 'parskala' ),
							'label_block' => true,
							'type' => \Elementor\Controls_Manager::TEXT,
							'placeholder' => __( 'ناموجود', 'parskala' ),
							'default' => __( 'ناموجود', 'parskala' ),
							'condition' => [
								'prk_show_unavailable_text' => 'true',
							],
						]
					);


		$this->end_controls_section();

		$this->start_controls_section(
		 'slider_special',
		 [
			 'label' => 'پیکربندی اسلایدر',
			 'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		 ]
		);

		$this->add_control(
				'loop',
				[
					'label' => 'حلقه نامحدود',
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => __( 'بله', 'your-plugin' ),
					'label_off' => __( 'خیر', 'your-plugin' ),
					'return_value' => 'true',
					'default' => 'false',
				]
			);

			$this->add_control(
					'nav',
					[
						'label' => 'پیکان ها',
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'label_on' => __( 'بله', 'your-plugin' ),
						'label_off' => __( 'خیر', 'your-plugin' ),
						'return_value' => 'true',
						'default' => 'true',
					]
				);
				$this->add_control(
						'autoplay',
						[
							'label' => 'نمایش خودکار',
							'type' => \Elementor\Controls_Manager::SWITCHER,
							'label_on' => __( 'بله', 'your-plugin' ),
							'label_off' => __( 'خیر', 'your-plugin' ),
							'return_value' => 'true',
							'default' => 'false',
						]
					);
							$this->add_control(
							'delay',
							[
								'label' => esc_html__( 'سرعت پخش', 'plugin-name' ),
								'type' => \Elementor\Controls_Manager::NUMBER,
								'min' => 100,
								'step' => 5,
								'default' => 3000,
							]
		);
		$this->add_control(
		'item',
				[
					'label' => esc_html__( 'تعداد ایتم ها', 'plugin-name' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 3,
					'max' => 8,
					'step' => 1,
					'default' => 5,
				]
    );

		$this->add_control(
			 'show_view_item',
			 [
					'label' => __( 'نمایش آیتم مشاهده همه', 'PRK' ),
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'default' => 'yes',

			 ]
		);


		$this->add_control(
			'border',
						[
						'label' => esc_html__( 'انحنا دور سکشن', 'plugin-name' ),
						'type' => \Elementor\Controls_Manager::NUMBER,
						'min' => 1,
						'step' => 1,
						'default' => '8',
							'selectors' => [
							'{{WRAPPER}} .right-product' => 'border-radius: {{VALUE}}px',
							],
						]
		);

		$this->end_controls_section();

		  /*HEADER*/
		  $this->start_controls_section(
			'header',
			[
				'label' => esc_html__( 'Header', 'wooslider-bymdez' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' 	=> ['header_enabled' => 'yes'],
			]
		);

		$this->add_control( //Just Refresh the frame
            'refresh_frame4',
            [
                'label' => esc_html__('Update Frame', 'wooslider-bymdez'),
                'description' => esc_html__('no effects on the functionality, just re-fresh the live view', 'wooslider-bymdez'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'refresh', 'wooslider-bymdez' ),
				'label_off' => esc_html__( 'refresh', 'wooslider-bymdez' ),
				'return_value' => 'yes',
				'default' => 'no',
            ]
        );

        $this->add_control(//def alignment of header elements
			'header_elems_align',
			[
				'label' => esc_html__( 'Header elements alignment', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'center'              => esc_html__('Center', 'wooslider-bymdez'),
                    'right'              => esc_html__('Right', 'wooslider-bymdez'),
					'left'          =>	esc_html__('Left', 'wooslider-bymdez'),
				],
                'default' => 'center',
			]
		);

        $this->add_control( //back to first slide after ajax
            'header_backtofirst_ajax',
            [
                'label' => esc_html__('Back to first-slide after Ajax', 'wooslider-bymdez'),
                'description' => esc_html__('after changing the category, jumps to the first-slide', 'wooslider-bymdez'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Active', 'wooslider-bymdez' ),
				'label_off' => esc_html__( 'Inactive', 'wooslider-bymdez' ),
				'return_value' => 'yes',
				'default' => 'yes',
            ]
        );
    
		$repeater = new \Elementor\Repeater();

        $repeater->add_control(//header make title
            'header_elems_maketitle',
            [
                'label' => esc_html__('Turn to Title', 'wooslider-bymdez'),
                'description' => esc_html__('When activated turns this button to an static title, and it will not have functionality anymore', 'wooslider-bymdez'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Active', 'wooslider-bymdez' ),
				'label_off' => esc_html__( 'Inactive', 'wooslider-bymdez' ),
				'return_value' => 'yes',
				'default' => 'no',
            ]
        );

        $repeater->add_control(//header make title theme
			'header_elems_maketitle_theme',
			[
				'label' => esc_html__( 'Title Theme', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'theme-1'              =>   esc_html__('Theme-1', 'wooslider-bymdez'),
                    'theme-2'              =>   esc_html__('Theme-2', 'wooslider-bymdez'),
					'theme-3'              =>	esc_html__('Theme-3', 'wooslider-bymdez'),
                    'theme-4'              =>	esc_html__('Theme-4', 'wooslider-bymdez'),
                    'theme-5'              =>	esc_html__('Theme-5', 'wooslider-bymdez'),
                    'theme-6'              =>	esc_html__('Theme-6', 'wooslider-bymdez'),
                    'none'                 =>	esc_html__('none', 'wooslider-bymdez'),
				],
                'condition' 	=> ['header_elems_maketitle' => 'yes'],
                'default' => 'theme-1',
			]
		);

		$repeater->add_control(//add or remove header elems
			'header_elems_title', [
				'label' => esc_html__( 'Title', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'cat-name' , 'wooslider-bymdez' ),
				'label_block' => true,
			]
		);

		$repeater->add_control(//Ajax cats
			'header_ajax_cats',
			[
				'label' 		=>	esc_html__( 'Categories', 'wooslider-bymdez' ),
				'type' 			=>	\Elementor\Controls_Manager::SELECT2,
				'description'   =>  esc_html__( 'Pick one cat', 'wooslider-bymdez' ),
				'label_block'	=>  'true',
				'multiple' 	    =>	false,
				'options' 		=>  $this->get_terms_mdz('product_cat'),
			]
		);

        $repeater->add_control( //ajax max number
			'header_products_number',
			[
				'label' 		=> esc_html__( 'Number', 'wooslider-bymdez' ),
				'type'			=> \Elementor\Controls_Manager::NUMBER,
				'return_value' 	=> 'true',
				'default' 		=> 15,
			]
		);

        $repeater->add_control(//def source of ajax products
			'header_products_src',
			[
				'label' => esc_html__( 'Source', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::SELECT,
                'label_block'	=>  'true',
				'options' => [
					'news'              => esc_html__('News', 'wooslider-bymdez'),
                    'olds'              => esc_html__('Olds', 'wooslider-bymdez'),
					'featured'          =>	esc_html__('Featured', 'wooslider-bymdez'),
					'sale'              =>	esc_html__('Sale', 'wooslider-bymdez'),
					'bestsellings'		=>	esc_html__('Most sales', 'wooslider-bymdez'),
                    'lowsellings'		=>	esc_html__('Lowest sales', 'wooslider-bymdez'),
                    'lastedited'		=>	esc_html__('Last modified', 'wooslider-bymdez'),
                    'rand'		        =>	esc_html__('random', 'wooslider-bymdez'),
				],
                'default' => 'news',
			]
		);

        $repeater->add_control(//Ajax stock ? in_stock
			'header_products_stock',
			[
				'label' => esc_html__( 'Stock', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::SELECT,
                'label_block'	=>  'true',
				'options' => [
					'all'                        => esc_html__('no matter', 'wooslider-bymdez'),
                    'only_instocks'              => esc_html__('only in-stocks', 'wooslider-bymdez'),
					'only_not_instocks'          =>	esc_html__('only outof-stocks', 'wooslider-bymdez'),
				],
                'default' => 'only_instocks',
			]
		);

        $repeater->add_control(//header icons show?
			'header_icons_type',
			[
				'label' => esc_html__( 'showing buttons', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
                    'none'              => esc_html__('No icon', 'wooslider-bymdez'),
                    'elem_icons'        => esc_html__('Elementor icons', 'wooslider-bymdez'),
                    'custom_icons'      => esc_html__('Your icon', 'wooslider-bymdez'),
				],
                'default' => 'none'
			]
		);

        $repeater->add_control(//sefl elem icons selector
			'header_icons_select',
			[
				'label' => esc_html__( 'Choose icon', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::ICONS,
                'condition' 	=> ['header_icons_type' => 'elem_icons'],
				'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
			]
		);

        $repeater->add_control(//sefl elem icons color
			'header_icons_color',
			[
				'label' => esc_html__( 'icon color', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'condition' 	=> ['header_icons_type' => 'elem_icons'],
				'default' => '#000',
			]
		);

        $repeater->add_control(//custom icon img selector
			'header_iconscustom_select',
			[
				'type' => \Elementor\Controls_Manager::MEDIA,
				'label' => esc_html__( 'Choose your icon', 'wooslider-bymdez' ),
                'description'   =>  esc_html__( 'prefered formats: svg & webp', 'wooslider-bymdez' ),
                'condition'  => ['header_icons_type' => 'custom_icons'],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
			]
		);

        $repeater->add_control( //custom icon img width
			'header_iconscustom_width',
			[
				'label' 		=> esc_html__( 'width', 'wooslider-bymdez' ),
				'type'			=> \Elementor\Controls_Manager::NUMBER,
                'description'   =>  esc_html__( 'in pixels (px)', 'wooslider-bymdez' ),
                'condition'  => ['header_icons_type' => 'custom_icons'],
				'return_value' 	=> 'true',
				'default' 		=> 45,
			]
		);

        $repeater->add_control(//text and icon alignment
			'header_texticon_alginment',
			[
				'label' => esc_html__( 'text & icon position', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::SELECT,
                'label_block'	=>  'true',
				'options' => [
                    'dir1'                 => esc_html__('default', 'wooslider-bymdez'),
                    'dir2'                 => esc_html__('icon left-text right', 'wooslider-bymdez'),
                    'dir3'                 => esc_html__('icon up-text down', 'wooslider-bymdez'),
                    'dir4'                 => esc_html__('icon down-text up', 'wooslider-bymdez'),
				],
                'default' => 'dir1',
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'header_icons_type',
                            'operator' => '===',
                            'value' => 'elem_icons'
                        ],
                        [
                            'name' => 'header_icons_type',
                            'operator' => '===',
                            'value' => 'custom_icons'
                        ]
                    ]
                ]
			]
		);

        $repeater->add_control(//ajax btn text color
			'header_text_color',
			[
				'label' => esc_html__( 'text color', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#000',
			]
		);

        $repeater->add_control( //header allcats btn
            'header_allcats_show',
            [
                'label' => esc_html__('Show see all slide?', 'wooslider-bymdez'),
                'description' => esc_html__('adds and extra slide to the end of slider', 'wooslider-bymdez'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Active', 'wooslider-bymdez' ),
				'label_off' => esc_html__( 'Inactive', 'wooslider-bymdez' ),
				'return_value' => 'yes',
				'default' => 'no',
            ]
        );

        $repeater->add_control(//header see all cats title
			'header_allcats_title', [
				'label' => esc_html__( 'Title (see all)', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::TEXT,
                'condition' 	=> ['header_allcats_show' => 'yes'],
				'default' => esc_html__( 'see all' , 'wooslider-bymdez' ),
				'label_block' => true,
			]
		);
        $repeater->add_control(//header see all cats title color
			'header_allcats_titlecolor',
			[
				'label' => esc_html__( 'Title color', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'condition' 	=> ['header_allcats_show' => 'yes'],
                'default' => '#000',
			]
		);

        $repeater->add_control(//header see all cats background
			'header_allcats_backtype',
			[
				'label' => esc_html__( 'Background type', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::SELECT,
                'condition' 	=> ['header_allcats_show' => 'yes'],
				'options' => [
                    'color'             => esc_html__('color', 'wooslider-bymdez'),
                    'wallpaper'        => esc_html__('picture', 'wooslider-bymdez'),
				],
                'default' => 'color'
			]
		);

        $repeater->add_control(//header see all cats background color
			'header_allcats_backcolor',
			[
				'label' => esc_html__( 'Background color', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'header_allcats_show',
                            'operator' => '===',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'header_allcats_backtype',
                            'operator' => '===',
                            'value' => 'color'
                        ]
                    ]
                ],
                'default' => '#fff',
			]
		);

        $repeater->add_control(//header see all cats background pic
			'header_allcats_backimg',
			[
				'type' => \Elementor\Controls_Manager::MEDIA,
				'label' => esc_html__( 'Choose a pic', 'wooslider-bymdez' ),
                'conditions' => [
                    'relation' => 'and',
                    'terms' => [
                        [
                            'name' => 'header_allcats_show',
                            'operator' => '===',
                            'value' => 'yes'
                        ],
                        [
                            'name' => 'header_allcats_backtype',
                            'operator' => '===',
                            'value' => 'wallpaper'
                        ]
                    ]
                ],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
			]
		);

        $repeater->add_control(
			'header_allcats_url',
			[
				'label' => esc_html__( 'URL', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::URL,
                'condition' 	=> ['header_allcats_show' => 'yes'],
				'placeholder' => esc_html__( 'https://your-site.com/category/test', 'wooslider-bymdez' ),
			]
		);

        $repeater->add_control( //header bg changer on or?
            'header_bgchanger',
            [
                'label' => esc_html__('Header bg-color change?', 'wooslider-bymdez'),
                'description' => esc_html__('After Ajax, change the back-color of the header based on your design', 'wooslider-bymdez'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'wooslider-bymdez' ),
				'label_off' => esc_html__( 'No', 'wooslider-bymdez' ),
				'return_value' => 'yes',
				'default' => 'yes',
            ]
        );

        $repeater->add_control(//header see all cats title color
			'header_bgchanger_color',
			[
				'label' => esc_html__( 'Choose a color', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::COLOR,
                'condition' 	=> ['header_bgchanger' => 'yes'],
                'default' => '#52ff68',
			]
		);


		$this->add_control(//the main repeater
			'header_elements',
			[
				'label' => esc_html__( 'Header Buttons', 'wooslider-bymdez' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'header_elems_title' => "1 دسته بندی",
                        'header_icons_type' => 'elem_icons',
                        'header_icons_select' => [
                            'value' => 'fas fa-heart',
                            'library' => 'solid',
                        ],
					],
                    [
						'header_elems_title' => "دسته بندی 2",
                        'header_icons_type' => 'elem_icons',
                        'header_icons_select' => [
                            'value' => 'fas fa-star',
                            'library' => 'solid',
                        ],
                        'header_texticon_alginment' => 'dir3',
					],
                    [
						'header_elems_title' => "دسته بندی 3",
                        'header_icons_type' => 'elem_icons',
                        'header_icons_select' => [
                            'value' => 'fas fa-heart',
                            'library' => 'solid',
                        ],
                        'header_texticon_alginment' => 'dir2',
					],
				],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

	 $theme_display = prk_option('theme-style');

		$settings = $this->get_settings_for_display();
		$slider_class = slider_RandomString();
		$border =   $settings['border'];
	 if (! $border){
		if ('parskala' == $theme_display){
			$border = '15';
		}else {
			$border = '8';
		}
	 }
		$title_icon = $settings['title_icon'];

		$title_border =  $settings['title_border'];
		$category_url =  $settings['category_url']['url'];

		if($settings['header_enabled']){
			$category_urlviewall = esc_attr($settings['header_elements'][0]['header_allcats_url']['url']);
		}else{
			$category_urlviewall =  $settings['category_url_viewall']['url'];

		}
		$settings_slider =  array(
			'loop' => $settings['loop'],
			'nav' => $settings['nav'],
			'autoplay' => $settings['autoplay'],
			'delay' => $settings['delay'],
			'item' => $settings['item'],
			'margins' => 5,
		);
		if ($title_border ==! 'yes') {
			$title_class = 'hide';
		}else {
			$title_class = '';
		}
		$json_settings = json_encode($settings_slider);


    if ( mobile_cheker() || tablet_cheker() ) {
 		 $class_dev = 'verticaler';
 		 $class_section = 'carousel_lister';
 		 // $class_item = 'article-off';
      $json_settings = '';
    }else {
 		 $class_dev = '';
      $class_section = 'article-off';
 		 // $class_item = 'article-off';
 		 $json_settings = json_encode($settings_slider);

    }

	// $product_cat = $settings['product_cat'];
	if($settings['header_enabled']){
		$product_cat = [esc_attr($settings['header_elements'][0]['header_ajax_cats'])];
		$tab_id=$product_cat[0];

	}else{
		$tab_id="";
	$product_cat = $settings['product_cat'];
	}
	if($settings['header_enabled']){
      $header_tab = "have_header_cat";
	}else{
	  $header_tab = "";
	}
		?>
    <section  class="col-product">

       <div class="right-product tab1">

				 <div class="head-product <?php echo $title_class;?> <?= $header_tab?>">
				 <div class="prks-tabs-loader">
					<span class="ajax-loader"></span>
				 </div>
			 			<h3>
			 				<span class="titles-pro <?php echo $title_class;?>">
					 			<?php if ($title_icon):?>
									<span class="<?php echo $title_icon ?> icon-carosel"></span>
								<?php endif;?>
								<div class="title-tab-prk">
									<div class="item-icon-title">
										<span><?php echo $settings['title_section'];?></span>
									</div>
							   </div>
			 		  	</span>
						<?php if ($category_url): ?>
			 		   	<a class="view-all" href="<?php echo $category_url;?>"><?php _e('view all' , 'parskala');?></a>
						<?php endif; ?>
			 		</h3>

					 <?php	if($settings['header_enabled']){ ?>
					  <!-- header buttons -->
					  <div class="prk-ajax-list-header-wrapper widget-tabs">
					<?php
					
							
					     //start rendering HEADER elements
						 foreach ( $settings['header_elements'] as $index => $item ) {
							switch($settings['header_elements'][$index]['header_texticon_alginment']){//prepare header text & icon alignment
								case 'dir1':
									$header_txticon_align = 'prk-texticon-wrapeer1';
									break;
								case 'dir2':
									$header_txticon_align = 'prk-texticon-wrapeer2';
									break;
								case 'dir3':
									$header_txticon_align = 'prk-texticon-wrapeer3';
									break;
								case 'dir4':
									$header_txticon_align = 'prk-texticon-wrapeer4';
									break;
							}
							$auth = '1';
							if ($settings['showonly_tologgedin'] == 'yes' && !is_user_logged_in()){
								$auth = '0';
							}

							?>
							<div cat="<?php echo esc_attr($settings['header_elements'][$index]['header_ajax_cats'])?>" number="<?php echo esc_attr($settings['header_elements'][$index]['header_products_number']) ?>" stock="<?php echo esc_attr($settings['header_elements'][$index]['header_products_stock']) ?>" type="<?php echo esc_attr($settings['header_elements'][$index]['header_products_src']) ?>" seeallcat="<?php echo esc_attr($settings['header_elements'][$index]['header_allcats_show']) ?>" <?php if($settings['header_elements'][$index]['header_allcats_backtype'] == 'color'){
								echo esc_attr('seeallcat_bgcolor='.$settings['header_elements'][$index]['header_allcats_backcolor']);
							}else if($settings['header_elements'][$index]['header_allcats_backtype'] == 'wallpaper') { echo esc_attr('seeallcat_bgwalp='.$settings['header_elements'][$index]['header_allcats_backimg']['url']);}?> seeallcat_title="<?php echo esc_attr($settings['header_elements'][$index]['header_allcats_title'])?>"
							seeallcat_titlecolor="<?php echo esc_attr($settings['header_elements'][$index]['header_allcats_titlecolor'])?>" seeallcat_link="<?php echo esc_attr($settings['header_elements'][$index]['header_allcats_url']['url'])?>" seeallcat_link_ext="<?php echo esc_attr($settings['header_elements'][$index]['header_allcats_url']['is_external'])?>" seeallcat_link_follow="<?php echo esc_attr($settings['header_elements'][$index]['header_allcats_url']['nofollow'])?>" auth="<?php echo esc_attr($auth); ?>"  bgchanger_color="<?php echo esc_attr($settings['header_elements'][$index]['header_bgchanger_color']) ?>" class="title-tab-prk prk-header-divs <?php echo($index==0 ? "prk-header-divs-active":"") ?> tab-item" <?php if($settings['header_elements'][$index]['header_elems_maketitle'] == 'yes'){echo 'no-btn'.' title-theme='.$settings['header_elements'][$index]['header_elems_maketitle_theme'];} ?>>
							
							<div class="<?php echo esc_attr($header_txticon_align); ?> item-icon-title">
							
							<?php if($settings['header_elements'][$index]['header_icons_type'] == 'elem_icons'){
							?><i style="color: <?php echo esc_attr($settings['header_elements'][$index]['header_icons_color']) ?> ;" class="<?php echo esc_attr($settings['header_elements'][$index]['header_icons_select']['value'])?>"></i> <?php
							}else if($settings['header_elements'][$index]['header_icons_type'] == 'custom_icons'){
								?><img style="width:<?php echo esc_attr($settings['header_elements'][$index]['header_iconscustom_width']) ?>px; height: auto;" src="<?php echo esc_attr($settings['header_elements'][$index]['header_iconscustom_select']['url']) ?>" alt="..."><?php
							}?>
							<span bgchanger="<?php echo esc_attr($settings['header_elements'][$index]['header_bgchanger']) ?>" style="color:<?php echo esc_attr($settings['header_elements'][$index]['header_text_color']); ?> ;"><?php echo esc_html($settings['header_elements'][$index]['header_elems_title']); ?></span>
			
							</div>
							</div> 
							<?php
						}

					?>
					  </div>
					  <?php } ?>
	 			</div>

    <div class="items-pro" >
		
      <div class="<?php echo $class_section;?>" tab-id="<?=$tab_id;?>" settings-slider='<?php echo $json_settings; ?>'>
        <?php

				$btnـcart_style =  $settings['btnـcart_style'];

											 $prod_sort = $settings['prod_sort'];
									 		$prod_filter = $settings['prod_filter'];
									 		$product_cat = $settings['product_cat'];
									 		$product_tag = $settings['product_tag'];
											$product_brand = $settings['product_brand'];

											if($settings['header_enabled']){
												$product_cat = [esc_attr($settings['header_elements'][0]['header_ajax_cats'])];

											}else{
												$product_cat = $settings['product_cat'];
											}

											// var_dump($product_cat);
											// die;


										 $view_all_link = '';
								 			if($prod_sort != 'special' && $prod_sort != 'rand_special') {
								 			switch ($prod_sort) {
								 				case 'latest':
								 					$arms = array(
								 					'posts_per_page' => $settings['ptotalcount'],
								 					'post_type' => 'product',
								 					'post_status' => 'publish',
								 					'order' => 'DESC'  );
								 					break;
								 				case 'menu_order':
								 					$arms = array(
								 					'posts_per_page' => $settings['ptotalcount'],
								 					'post_type' => 'product',
								 					'post_status' => 'publish',
								 					'orderby' => 'menu_order title',
								 					'order' => 'ASC'  );
								 					break;
								 				case 'saled':
								 					$arms = array(
								 					'posts_per_page' => $settings['ptotalcount'],
								 					'post_type' => 'product',
								 					'post_status' => 'publish',
								 					'meta_key' => 'total_sales',
								                     'orderby' => 'meta_value_num',
								                     'order' => 'DESC'  );
								 					break;
								 				case 'discounted':
								 					$arms = array(
								 						'posts_per_page'    => $settings['ptotalcount'],
								 						'post_status'       => 'publish',
								 						'order' => 'DESC',
								 						'post_type'         => 'product',
								 						'post__in'          => array_merge( array( 0 ), wc_get_product_ids_on_sale() )
								 					);
								 					break;
								 				case 'coming_soon':
								 					$arms = array(
								 						'posts_per_page' => $settings['ptotalcount'],
								 						'post_type' => 'product',
								 						'post_status' => 'publish',
								 						'meta_key' => 'prk_coming',
								 						'meta_value' => 'yes',
								 						'order' => 'DESC'
													 );
								 					break;
								 				case 'rand_discounted':
								 					$arms = array(
								 						'posts_per_page'    => $settings['ptotalcount'],
								 						'post_status'       => 'publish',
								 						'orderby'        	=> 'rand',
								 						'post_type'         => 'product',
								 						'post__in'          => array_merge( array( 0 ), wc_get_product_ids_on_sale() )
								 					);
								 					break;
								 				case 'viewed':
								 					$arms = array(
								 					'posts_per_page' => $settings['ptotalcount'],
								 					'post_type' => 'product',
								 					'post_status' => 'publish',
													'order'            => 'DESC',
											    'suppress_filters' => false,  //required param
											    'orderby'          => 'post_views',  //required param
													);
								 					break;
								 				case 'price-desc':
								 					$arms = array(
								 					'posts_per_page' => $settings['ptotalcount'],
								 					'post_type' => 'product',
								 					'post_status' => 'publish',
								 					'orderby'        => 'meta_value_num',
								 					'meta_key'       => '_price',
								 					'order'          => 'DESC');
								 					break;
								 				case 'price-asc':
								 					$arms = array(
								 					'posts_per_page' => $settings['ptotalcount'],
								 					'post_type' => 'product',
								 					'post_status' => 'publish',
								 					'orderby'        => 'meta_value_num',
								 					'meta_key'       => '_price',
								 					'order'          => 'ASC');
								 					break;
								 				case 'random':
								 					$arms = array(
								 					'posts_per_page' => $settings['ptotalcount'],
								 					'post_type' => 'product',
								 					'post_status' => 'publish',
								 					'orderby'        => 'rand'  );
								 					break;
								 				default:
								 				$arms = array(
								 					'posts_per_page' => $settings['ptotalcount'],
								 					'post_type' => 'product',
								 					'post_status' => 'publish',
													'meta_key' => 'onsales_round',
													'meta_value' => 'yes',
								 				 );
								 				}
								 				if ( $prod_filter ) {
								 					if ( $prod_filter == 'category' && !empty($product_cat) ) {
								 						$arms['tax_query'] = array(
								 							array(
								 							'taxonomy' => 'product_cat',
								 							'field' => 'term_id',
								 							'terms' => $product_cat
								 							)
								 						);
								 						$view_all_link = prk_get_term_links( 'product_cat', $product_cat );
								 					} elseif ( $prod_filter == 'tag' && !empty($product_tag) ) {
								 						$arms['tax_query'] = array(
								 							array(
								 							'taxonomy' => 'product_tag',
								 							'field' => 'term_id',
								 							'terms' => $product_tag
								 							)
								 						);
								 						$view_all_link = prk_get_term_links( 'product_tag', $product_tag );
								 					} elseif ( $prod_filter == 'brand' && !empty($product_brand) ) {
								 						$arms['tax_query'] = array(
								 							array(
								 							'taxonomy' => 'brand',
								 							'field' => 'term_id',
								 							'terms' => $product_brand
								 							)
								 						);
								 						$view_all_link = prk_get_term_links( 'brand' , $product_brand );
								 					}elseif ( $prod_filter == 'pro_id' && !empty($product_id) ) {
														$arms['tax_query'] = array(
								 							array(
														    'post__in' => array( $product_id),
								 							)
								 						);
								 					}
								 				}
								 			} elseif ( $prod_sort == 'special' || $prod_sort == 'rand_special') {


												$arms = array (
														'posts_per_page' => $settings['ptotalcount'],
														'post_type' => 'product',
														'post_status' => 'publish',
														'meta_key' => 'onsales_round',
														'meta_value' => 'yes',

												);


								 					if ( !empty($prod_filter) && (!empty($product_cat) || !empty($product_tag) || !empty($product_brand)) ) {
								 					if ( $prod_filter == 'category' && !empty($product_cat) ) {
								 						$arms['tax_query'] = array(

								 						array(
								 						'taxonomy' => 'product_cat',
								 						'field' => 'term_id',
								 						'terms' => $product_cat
								 						)
								 					);
								 					} elseif ( $prod_filter == 'tag' && !empty($product_tag) ) {
								 						$arms['tax_query'] = array(

								 						array(
								 						'taxonomy' => 'product_tag',
								 							'field' => 'term_id',
								 							'terms' => $product_tag
								 						)
								 					);
								 					} elseif ( $prod_filter == 'brand' && !empty($product_brand) ) {
								 						$arms['tax_query'] = array(

								 							array(
								 							'taxonomy' => 'brand',
								 								'field' => 'term_id',
								 								'terms' => $product_brand
								 							)
								 						);
								 					}
								 				}

												if ( $prod_sort == 'special' ) {
													$args['order'] = 'DESC';
												} elseif ( $prod_sort == 'rand_special') {
													$args['orderby'] = 'rand';
												}

								 			}

								 			if('yes' === $settings['out_prod'] ){
								 				$arms['meta_query'] = array(
								 						'relation' => 'AND',
								 						array(
								 							'key' => '_stock_status',
								 							'value' => 'instock'
								 						),
								 					);
								 			}

								 			$arms[] = array(
								 				'fields'                    => 'ids',
								 				'no_found_rows'             => true,
								 				'update_post_term_cache'    => false
								 			);

											if(isset($_COOKIE['prskalaSearchCity']) && !empty(($_COOKIE['prskalaSearchCity']))){
												 $city_categories=explode(',', $_COOKIE['prskalaSearchCity']);
												 if (!empty($city_categories) && $city_categories !== 0) {
													 if (is_array($arms["tax_query"])) {
														 $arms["tax_query"][] = ["taxonomy" => "city_categories", "field" => "id", "terms" => $city_categories];
													 } else {
														 $arms["tax_query"] = ["relation" => "AND", ["taxonomy" => "city_categories", "field" => "id", "terms" => $city_categories]];
													 }
												 }
										 }

             $pd_query = new WP_Query( $arms );
             if ($pd_query ->have_posts()) {
             	$cate_empty = '';
						}else {
							$cate_empty = 'cate_empty';
						}

						  ?>
             <?php if ( $pd_query ->have_posts() ) : ?>

               <?php while ( $pd_query ->have_posts() ) : $pd_query ->the_post(); ?>
								 <?php
 								global $product;
 								global $woocommerce;
 								$currency = get_woocommerce_currency_symbol();
 								$price = get_post_meta( get_the_ID(), '_regular_price', true);
 								$sale = get_post_meta( get_the_ID(), '_sale_price', true);
 								$img_up_pro = get_post_meta(get_the_ID(),'img_up_pro',true);
								$product_label = get_post_meta(get_the_ID(), 'prk_product_label', true );
								$thumber = get_the_post_thumbnail();
								$imager  = wc_placeholder_img_src();
 								?>
 								<article class="item-pro">

									<?php if ($product_label): ?>
										<div class="custom_label"><span><?php echo $product_label;?></span></div>
									<?php endif; ?>

 								    <a href="<?php the_permalink();?>">

											<!--thumbnail-->
											<?php echo pr_img(); ?>

 								      <div class="index-title-pro">
 								         <h2><?php echo wp_trim_words(get_the_title(),12,'...') ;?></h2>
 								      </div>

											<?php
 											 echo '<div class="index-prices-pro">';

 												 if ( $product->is_in_stock() ) {

 													 echo '<div class="price_onsale_ar">';

													  if ( $product->is_in_stock() && $price || $product->is_type( 'variable' ) ) {
 																	echo $product->get_price_html();
															}elseif( $product->is_in_stock()  ){
																echo '<p class="call_pro">'.prk_option('single_product_text_price').'</p>';
 																}


 													 echo '</div>';

 												 }else{
													  echo '<div class="price_onsale_ar">';
													 		if($settings['prk_show_unavailable_text']){
															echo '<p class="call_pro">'.$settings['prk_unavailable_text'].'</p>';
													     }
													  echo '</div>';
 												 }
 												echo '</div>';
 											 ?>

													<?php if( $product->is_purchasable() && $product->is_in_stock() && $settings['showـbtnـcart']):?>

														<?php if( 'icon' == $btnـcart_style):?>

															<div class="lists_add_to_cart">
																<?php echo do_shortcode("[ajax_cart_item]");?>
															</div>

													  <?php elseif ( 'text' == $btnـcart_style):?>

														 <div class="product-cart" >
											  			<?php echo do_shortcode("[ajax_cart_ver2]");?>
														 </div>

													  <?php endif;?>

												 <?php endif;?>


 								      </a>
 								</article>

                <?php endwhile; ?>
        <?php wp_reset_postdata(); ?>
          <?php endif;?>

					<!-- المان مشاهده بیشتر -->
 				 <?php if ( $settings['show_view_item'] == 'yes' && $settings['autoplay'] == 'false' ): ?>
 				   <div class="off-product mories <?php echo $cate_empty;?>">
 					   <a href="<?php echo $category_urlviewall; ?>">
 					     <div class="w-categorys-link">
 					       <i class="ri-arrow-left-line"></i>
 								 <span>مشاهده همه</span>
 					     </div>
 						</a>
 				   </div>
          <?php endif; ?>

      </div>
	</div>
			</div>
    </section>
		<?php

	}
	protected function get_terms_mdz( $taxonomy, $top_level_only = false, $with_empty = true ) {

		$args = array(
			'taxonomy'      => $taxonomy,
			'hide_empty'    =>	false,
			'include' 		=> 'all',
		);
		
		if ( $top_level_only )
			$args['parent'] = 0;

		$the_query = new \WP_Term_Query($args);
		$list = array();
		if ( $with_empty ) 
			$list[] = __( 'Choose', 'wooslider-bymdez' );

		foreach( $the_query->get_terms() as $term ) { 
			$id = $term->term_id;
			$list[$id] = $term->name . ' (id - ' . $id . ')';
		}

		return $list;
	}

	function my_plugin_styles() {
		wp_enqueue_style('frontcss', get_template_directory_uri()."/inc/wooslider-bymdez/front/css/frontcss.css");
		wp_enqueue_script('frontjs', get_template_directory_uri()."/inc/wooslider-bymdez/front/js/frontjs.js",array('jquery'),null,true);

	}

	
	protected function _content_template() {}

}
