<?php

class sldiers_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'sldiers';
	}

	public function get_title() {
		return __( 'اسلایدر اختصاصی', 'prk' );
	}

  public function get_icon() {
    return 'eicon-hotspot';
  }

  public function get_categories() {
    return [ 'prk-category' ];
  }

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'اسلایدر اختصاصی', 'prk' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'list_title', [
				'label' => __( 'عنوان', 'prk' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'اسلایدر اول' , 'prk' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'list_link', [
				'label' => __( 'لینک', 'prk' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#' , 'prk' ),
			]
		);

		$repeater->add_control(
			'list_image',
			[
				'label' => __( 'انتخاب تصویر', 'prk' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
			]
		);
		$repeater->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'default' => 'large',
			]
		);
		$this->add_control(
			'list',
			[
				'label' => __( 'لیست برند', 'prk' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_title' => __( 'کارت گرافیک', 'prk' ),
					],
				],
				'title_field' => '{{{ list_title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
		 'slider_special',
		 [
			 'label' => 'پیکربندی اسلایدر',
			 'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		 ]
		);

		$this->add_control(
				'loop',
				[
					'label' => 'حلقه نامحدود',
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => __( 'بله', 'your-plugin' ),
					'label_off' => __( 'خیر', 'your-plugin' ),
					'return_value' => 'true',
					'default' => 'true',
				]
			);
		$this->add_control(
				'nav',
				[
					'label' => 'پیکان ها',
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => __( 'بله', 'your-plugin' ),
					'label_off' => __( 'خیر', 'your-plugin' ),
					'return_value' => 'true',
					'default' => 'true',
				]
			);

		$this->add_control(
			'dots',
					[
						'label' => esc_html__( 'نمایش نقطه ها', 'plugin-name' ),
						'type' => \Elementor\Controls_Manager::SWITCHER,
						'return_value' => 'true',
						'default' => 'true',
					]
    );
		$this->add_control(
				'autoplay',
				[
					'label' => 'نمایش خودکار',
					'type' => \Elementor\Controls_Manager::SWITCHER,
					'label_on' => __( 'بله', 'your-plugin' ),
					'label_off' => __( 'خیر', 'your-plugin' ),
					'return_value' => 'true',
					'default' => 'false',
				]
			);

		$this->add_control(
			'delay',
			[
				'label' => esc_html__( 'سرعت پخش', 'plugin-name' ),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 100,
				'step' => 5,
				'default' => 3000,
			]
		);
		$this->add_control(
				'border',
				[
					'label' => esc_html__( 'انحنا دور سکشن(فقط عدد)', 'plugin-name' ),
					'type' => \Elementor\Controls_Manager::NUMBER,
					'min' => 0,
					'step' => 1,
					'default' => '8',
					'selectors' => [
						'{{WRAPPER}} .slider-right.ver1 img' => 'border-radius: {{VALUE}}px',
						'{{WRAPPER}} .slider-right.ver1' => '-moz-border-radius: {{VALUE}}px',
						'{{WRAPPER}} .slider-right.ver1' => '-webkit-border-radius: {{VALUE}}px',
					],
				]
		);

		$this->end_controls_section();

	}

	protected function render() {
  $settings = $this->get_settings_for_display();



		$settings_slider =  array(
			'loop' => $settings['loop'] ? $settings['loop'] : 'false',
			'nav' => $settings['nav'] ? $settings['nav'] : 'false',
			'dots' => $settings['dots'] ? $settings['dots'] : 'false',
	    'autoplay' => $settings['autoplay'] ? $settings['autoplay'] : 'false',
			'delay' => $settings['delay'] ? $settings['delay'] : 'false',
		);
		$json_settings = json_encode($settings_slider);




		if ( $settings['list'] ):?>

      <div class="slider-right ver1">


            <div class="slide-carousel" settings-slider='<?php echo $json_settings;?>'>
              <?php
			         	foreach (  $settings['list'] as $item ):

									?>

                <div class="slide-pre">

									<a href="<?php echo $item['list_link'];?>">
										<?php	echo \Elementor\Group_Control_Image_Size::get_attachment_image_html($item, 'shop_catalog', 'list_image');?>
								  </a>

								</div>


              <?php endforeach;?>
          </div>

       </div>


		<?php endif;?>

    <?php
	}

	protected function _content_template() {}
}
