<?php
require_once __DIR__."/../prk-sms/prk-sms.php";


class NotifyProductActivity{

    private $product_id;
    private $notifyBy;
    private $product;
    private $product_type;
    private $instock;
    private $amazing;
    private $checkboxes=[];
    private $billing_phone;
    private $user_id;
    private $results_status='';
    private $html="";
    const EVENTS_PATTERNS=[
        '_mojoodi'=>['name' =>'instock_product','param'=>'product'],
        '_shegeft'=>['name'=>'amazing_product','param'=>'onsale_product']
    ];
    private $results=[
        'add'=>[
            'type' => "success",
            'msg' => "شماره با موفقیت ذخیره شد"
        ],
        'update'=>[
            'type' => "success",
            'msg' => "شماره بروزرسانی شد"
        ],
        'updateEvent'=>[
            'type' => "success",
            'msg' => "لیست اطلاع رسانی بروزرسانی شد"
        ],
        'is_null'=>[
            'type' => "error",
            'msg' => "فیلد شماره تلفن نباید خالی باشد"
        ],
        'must_login'=>[
            'type' => "error",
            'msg' => "کاربر گرامی لطفا اول ثبت نام کنید"
        ],
        'unexpected'=>[
            'type' =>"error",
            'msg' => "خطای غیرمنتظره"
        ],
        "must_select_notifyBy"=>[
            'type' =>"error",
            'msg' => "لطفا روش اطلاع رسانی را انتخاب کنید"
        ],
        "must_select_notifyOptions"=>[
            'type' =>"error",
            'msg' => "لطفا مورد اطلاع رسانی را انتخاب کنید"
        ],
        "deleted_notify"=>[
            'type' =>"success",
            'msg' => "اطلاع رسانی برای این محصول غیر فعال شد"
        ],


    ];

    function __construct($productid=null,$userid=null)
    {
        if(!empty($userid) && !empty($productid)){
            $this->user_id = $userid;
            $this->product_id = $productid;

        }
        $this->load_hook();
        $this->init();
    }


    public function load_hook(){
        add_action("wp_ajax_stock_notify", [$this,"stock_notify"]);
        add_action("wp_ajax_nopriv_stock_notify", [$this,"please_login"]);
        add_action( 'woocommerce_update_product', [$this,'on_product_save'], 10, 1 );
        add_action('woocommerce_single_product_summary',[$this,'wsps'],30);
        add_action('wp_footer',[$this,'add_ajaxex_in_footer']);
        add_action( 'init', [$this,'script_enqueuer']);


    }

    function my_phpmailer_smtp( $phpmailer ) {
        $phpmailer->isSMTP();
        $phpmailer->Host = SMTP_server;
        $phpmailer->SMTPAuth = SMTP_AUTH;
        $phpmailer->Port = SMTP_PORT;
        $phpmailer->Username = SMTP_username;
        $phpmailer->Password = SMTP_password;
        $phpmailer->SMTPSecure = SMTP_SECURE;
        $phpmailer->From = SMTP_FROM;
        $phpmailer->FromName = SMTP_NAME;
    }

    function postfield($field){
        return (!empty($field) && is_string($field))?$_POST[$field]:null;
    }

    // function my_account_saving_billing_mobile_phone( $user_id ) {
    //     if( isset($_POST['billing_mobile_phone']) && ! empty($_POST['billing_mobile_phone']) )
    //     $this->update_phone_user_for_notify_product_activity($_POST['billing_mobile_phone']);
    // }


    // function update_phone_user_for_notify_product_activity($billing_mobile_phone){
    //     if($billing_mobile_phone != $this->billing_phone && $this->check_tels_subscribed($billing_mobile_phone)){
    //         update_post_meta($this->product_id,'_tel',$billing_mobile_phone,$this->billing_phone);
    //     }
    //     if($this->check_instock_subscribed($billing_mobile_phone,)){
    //         update_post_meta($this->product_id,'_mojoodi',$billing_mobile_phone,$this->billing_phone);
    //      }

    //      if($this->amazing && $this->check_amazing_subscribed($this->billing_phone)){
    //         update_post_meta($this->product_id,'_shegeft',$billing_mobile_phone,$this->billing_phone);
    //     }
    //     $this->results_status='update';
    // }
    function init(){

        $this->user_id = get_current_user_id();
        $this->billing_phone = get_user_meta($this->user_id, 'billing_phone', true);
        $this->billing_email = get_user_meta($this->user_id, 'billing_email', true);

    }

    function loadHtml(){
        $this->instock = $this->check_in_stock();
        $this->amazing = $this->check_amazing();
        $this->product_type = $this->check_product_type();
        $this->html_init();

    }

    function html_init(){
        if($this->amazing){
            $this->html .="<p id='sp'></p>";
        }

        $this->html .= "
        <div class='simple_elems'>
        <div id='notifyproduct' class='remodal remodal-xs remodal-maxed remodal-lg notifyproduct' data-remodal-id='notifyproduct' data-remodal-options='hashTracking: false'>
        <div class='remodal-header'>
            <div class='remodal-title'>مرا اگاه کن</div>
            <button data-remodal-action='close' class='remodal-close'></button>
        </div>
        ";

        if($this->product_type == 'simple'){
            $this->html .= "<div class='simple_elems'>";
        }elseif($this->product_type == 'variable'){
            $this->html .= "<div class = 'varelem'>";

        }

        $this->html .= "<p id='notice'></p><br>";
        $nphone_user = '';
        if( $this->billing_phone != ''){
            $nphone_user = $this->billing_phone;
        }

        $nemail_user = $this->billing_email;
       $this->html .= "<div class='swichers_notify'>";
       $class_checked = '';
        if(!$this->instock){
            $checked='';
            if($this->check_instock_subscribed($this->user_id)){
                $checked= 'checked';
                $class_checked="subscribed";
            }

            $this->html .= "
            <div class='flex_right swicher'>
              <label class='switch' >
                <lable class='mojoodi $class_checked' for='mojoodi'></lable>
                <input class='check_before' type='checkbox'  name='mojoodi' id='mojoodi'".$checked.">
                <span class='slider'></span>
              </label>
              <label class='swich_before' for='mojoodi'>اطلاع از موجودی محصول</label>
            </div>
            ";
        }

        if(!$this->amazing){
            $checked='';
            if($this->check_amazing_subscribed($this->user_id)){
                $checked= 'checked';
                $class_checked="subscribed";

            }
            $this->html .= "
            <div class='flex_right swicher'>
              <label class='switch' >
                <lable class='shegeft' for='shegeft'></lable>
                <input class='check_before'  type='checkbox' value='' name='shegeft' id='shegeft'".$checked.">
                <span class='slider'></span>
              </label>
              <label class='swich_before' for='shegeft'>اطلاع از شگفت انگیز شدن محصول</label>
            </div>
            ";
        }
        $this->html .= "</div>";

        $checked = '';
        if($this->check_user_notifypid($this->user_id) == 1 || $this->check_user_notifypid($this->user_id) == 3){
            $checked = 'checked';
        }
        $this->html .= "<div class='notify_title'>از طریق:</div>";

        $this->html .= "<ul class='notify_sender'>";

        $this->html .= "
        <li>
        <label><input type='checkbox' name='notifyByEmail' id='notifyByEmail'".$checked."></label>
        <label class='text_label' for='notifyByEmail'>ایمیل به : ".$nemail_user."</label>
        </li>";

        $checked = '';
        if($this->check_user_notifypid($this->user_id) == 2 || $this->check_user_notifypid($this->user_id) == 3){
            $checked = 'checked';
        }


        $this->html .= "<li>
        <label><input type='checkbox' name='notifyBySMS' id='notifyBySMS'".$checked."></label>
        <label class='text_label' for='notifyBySMS'>پیامک به ".$nphone_user."</label>
        </li>";

        $this->html .= "</ul>";

        $this->html .= "<input type='hidden' name='id_invis' class='stock_data_invis' data-user_id='" .$this->user_id . "' data-post_id='" . $this->product_id . "'><a class='stock_data' href = '#'> ثبت </a>";

        $this->html .= "</div></div>";
        $this->html .= "</div>";
        echo $this->html;

    }
    function stock_notify() {
        // $post_tel = $_POST['tel'];
        $this->product_id = $_POST['id'];
        if($this->accept_event($_POST['shegeft'])){
            $this->checkboxes[]='amazing';
        }

        if($this->accept_event($_POST['mojoodi'])){
            $this->checkboxes[]='instock';
        }


        $this->notifyBy=$this->notifyBy($_POST['notifyBy']);
        // $this->user_id = $_POST['userid'];
        $this->user_id = get_current_user_id();
        $this->billing_phone = get_user_meta($this->user_id, 'billing_phone', true);
        $this->tel_subscribe($this->user_id);


    }

    function notifyBy($by){
        if(is_array($by)){
            if(in_array('sms',$by) && in_array('email',$by)){
                return  3;
            }elseif(in_array('sms',$by)){
                return 2;
            }elseif(in_array('email',$by)){
                return 1;
            }
        }

        return 0;



    }

    function accept_event($event){

        return ($event =='t') ? true:false;

    }
    function check_instock_subscribed($userid){
        return in_array($userid,get_post_meta($this->product_id,'_mojoodi',false));
    }

    function check_amazing_subscribed($userid){
        return in_array($userid,get_post_meta($this->product_id,'_shegeft',false));
    }

    function check_notify_subscribed($userid){
        return in_array($userid,get_post_meta($this->product_id,'_notifyid',false));
    }

    function check_user_notifypid($userid){
        return get_user_meta($userid,'_notifypid_'.$this->product_id,true);
    }



    function has_list_phone_subscribed($meta_key){
        $notifyid = get_post_meta($this->product_id,'_notifyid',false);
        // $stock_status = get_post_meta($this->product_id, '_stock_status', true );
        $list_meta_key = get_post_meta($this->product_id, "$meta_key", false );

        if(!empty($notifyid) && !empty($list_meta_key) && $this->check_in_stock()){
            return true;
        }

        return false;

    }



    function add_to_subscribe_list($userid){

        if(empty($this->checkboxes) && !$this->check_amazing_subscribed($userid) && !$this->check_instock_subscribed($userid)){

            $this->echoResult($this->results["must_select_notifyOptions"]);

        }


        if(in_array('instock',$this->checkboxes) && !$this->check_instock_subscribed($userid)){

                add_post_meta($this->product_id,'_mojoodi',$userid,false);

         }elseif((!in_array('instock',$this->checkboxes)) && $this->check_instock_subscribed($userid)){
            delete_post_meta($this->product_id, '_mojoodi' , $userid);

         }
        if(in_array('amazing',$this->checkboxes) && !$this->check_amazing_subscribed($userid)){

                add_post_meta($this->product_id,'_shegeft',$userid,false);

        }elseif((!in_array('amazing',$this->checkboxes)) && $this->check_amazing_subscribed($userid)){
                delete_post_meta($this->product_id, '_shegeft' , $userid);
         }

        if(empty($this->checkboxes)){

            if($this->check_user_notifypid($userid)){
                delete_user_meta($userid,'_notifypid_'.$this->product_id);
            }

            if($this->check_notify_subscribed($userid)){
                delete_post_meta($this->product_id,'_notifyid',$userid);
            }

            $this->echoResult($this->results["deleted_notify"]);

        }


        $this->results_status='updateEvent';
    }

    function tel_subscribe($userid){

        if(! $this->check_notify_subscribed($userid))
        {

            if(add_post_meta($this->product_id,'_notifyid',$userid,false)){
                $this->results_status='add';
            }

        }
        if(($notifyBy_prev = $this->check_user_notifypid($userid)) && $this->check_notify_subscribed($userid))
        {
            if($this->notifyBy == 0){
                // $this->echoResult($this->results["must_select_notifyBy"]);
                delete_user_meta($userid,'_notifypid_'.$this->product_id);
                delete_post_meta($this->product_id,'_notifyid',$userid);
                if($this->check_instock_subscribed($userid)){
                    delete_post_meta($this->product_id, '_mojoodi' , $userid);
                }
                if($this->check_amazing_subscribed($userid)){
                    delete_post_meta($this->product_id, '_shegeft' , $userid);
                }

                $this->echoResult($this->results["deleted_notify"]);
            }else{
                if($notifyBy_prev != $this->notifyBy)
                update_user_meta($userid,'_notifypid_'.$this->product_id,$this->notifyBy,$notifyBy_prev);
            }



        }else{
            if($this->notifyBy == 0){
                $this->echoResult($this->results["must_select_notifyBy"]);
            }
            add_user_meta($userid,'_notifypid_'.$this->product_id,$this->notifyBy,false);

        }

        $this->add_to_subscribe_list($userid);
        $this->NotifyProductActivityResult();



    }

    function NotifyProductActivityResult(){
        if(!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
            if($this->results_status){
                $this->echoResult($this->results[$this->results_status]);
            }
         }
         $this->echoResult($this->results["unexpected"]);
    }

    function echoResult($status){

        echo json_encode($status);
        die;

    }

    function please_login() {

        $this->echoResult($this->results["must_login"]);

    }

    function notify_subcribers(){
        $sale_price = get_post_meta( $this->product_id, '_sale_price', true );
        $is_amazing = get_post_meta( $this->product_id, 'onsales_round', true );
        if($this->has_list_phone_subscribed('_mojoodi')){
            $this->stock_changed();
        }

        if($this->has_list_phone_subscribed('_shegeft') && $is_amazing == 'yes'){
            if($this->product->is_type('variable')) {
                // var_dump($sale_price);
                // die;
                $variation_ids = $this->product->get_children();
                foreach($variation_ids as $variation_id){
                    $check_sale_price = get_post_meta( $variation_id, '_sale_price', true );
                    if($check_sale_price !=''){
                        // var_dump($check_sale_price);
                        // die;
                        $sale_price = true;
                    }
                }
            }

            if($sale_price !=''){
                $this->shegeftangiz();
            }
        }
    }

    function on_product_save( $product_id ) {
        $this->product_id = $product_id;
        $this->product = wc_get_product( $product_id );
        $this->notify_subcribers();

     }

     function check_in_stock(){
        return (get_post_meta( $this->product_id, '_stock_status', true ) == 'instock' || $this->product->is_in_stock())? true:false;
     }

    function check_amazing(){
        if((get_post_meta( $this->product_id, 'onsales_round', true ) == 'yes')){
            if($this->check_product_type()=='variable') {
                $variation_ids = $this->product->get_children();
                foreach($variation_ids as $variation_id){
                    $sale_price = get_post_meta( $variation_id, '_sale_price', true );
                    if($sale_price !=''){
                        return true;
                    }
                }
            }elseif($this->check_product_type()=='simple'){
                $sale_price = get_post_meta( $this->product_id, '_sale_price', true );
                if($sale_price !=''){
                    return true;
                }
            }
        }

        return false;

    }

    function check_product_type(){
        if($this->product->is_type('simple')){
            return 'simple';
        }elseif($this->product->is_type('variable')){
            return 'variable';
        }
    }

    function sendSMS($notifyid,$event_name){
        if(!isset(self::EVENTS_PATTERNS[$event_name]))return false;
        $to = get_user_meta( $notifyid, 'billing_mobile_phone', true );
        $name = $this->product->get_name();

        $data=["to"=>$to,
        "pattern"=>[
            "name"=>self::EVENTS_PATTERNS[$event_name]['name'],
            "params"=>[[
                "name" => self::EVENTS_PATTERNS[$event_name]['param'],
                "value" => $name
            ]]
        ]
        ];

        $payamak = (new PRKSMS)->sendPattern($data);

        if($payamak && $payamak['success']){
            delete_post_meta($this->product_id,$event_name,$notifyid);
            return true;
        }
    }

    function sendEmail($notifyid,$event_name){
        $from = apply_filters( 'woocommerce_email_from_address', get_option( 'woocommerce_email_from_address' ));
        $info = get_user_by('id',$notifyid);
        $to = $info->user_email;
        $headers = "From:" . $from;
        $message = 'get from codestar';
        $email=wp_mail( $to, "test", $message,$headers);
        if($email){
            delete_post_meta($this->product_id,$event_name,$notifyid);
            return true;
        }
    }

    function sendAllNotify($notifyid){
        $sms=$this->sendSMS($notifyid,'_mojoodi');
        $email=$this->sendEmail($notifyid,'_mojoodi');
        if($sms && $email){
            delete_user_meta($notifyid,'_notifypid_'.$this->product_id);
        }else{
            if($sms){
                update_user_meta($notifyid,'_notifypid_'.$this->product_id,1,3);
            }
            if($email){
                update_user_meta($notifyid,'_notifypid_'.$this->product_id,2,3);
            }
        }


    }

    function stock_changed() {

        $this->product_id = $this->product->get_id();
		$name = $this->product->get_name();

        if ($this->check_in_stock()){

            if ($notify_records=$this->get_phones_meta_key("_notifyid")){
               foreach($notify_records as $notifyid)
                {
					if($this->check_instock_subscribed($notifyid))
					{
                        if($this->check_user_notifypid($notifyid)== 1){
                            $this->sendEmail($notifyid,'_mojoodi');
                         }elseif($this->check_user_notifypid($notifyid)==2){
                            $this->sendSMS($notifyid,'_mojoodi');
                         }elseif($this->check_user_notifypid($notifyid)== 3){
                            $this->sendAllNotify($notifyid);
                         }



                    }

				}

             }
        }
    }


     function shegeftangiz(){

        $this->product_id = $this->product->get_id();
		$name = $this->product->get_name();
        if ($this->check_in_stock()){
            if ($notify_records=$this->get_phones_meta_key("_notifyid")){
               foreach($notify_records as $notifyid)
                {
					if($this->check_amazing_subscribed($notifyid))
					{
                        if($this->check_user_notifypid($notifyid)== 1){
                            $this->sendEmail($notifyid,'_shegeft');
                         }elseif($this->check_user_notifypid($notifyid)==2){
                            $this->sendSMS($notifyid,'_shegeft');
                         }elseif($this->check_user_notifypid($notifyid)== 3){
                            $this->sendAllNotify($notifyid);
                         }



                    }
				}
             }
        }


 }

 function get_phones_meta_key($meta_key){
        $meta_key_values=get_post_meta($this->product_id,$meta_key,false);
        return !empty($meta_key_values) ? $meta_key_values  : null;

 }








function wsps(){
    global $product;
    $this->product_id = $product->get_id();
    $this->product = $product;

    if((!$this->check_in_stock() || !$this->check_amazing()))
    {
        echo $this->loadHtml();
    }
}

function add_ajaxex_in_footer()
{


    ?>

<?php
}


function script_enqueuer() {


    wp_register_script( "stock_notify", get_template_directory_uri() . "/inc/notify-product-activity/assets/js/stock_notify.js", array('jquery') );


    wp_localize_script( 'stock_notify', 'myAjax', array( 'ajaxurl' => admin_url( 'admin-ajax.php' )));


    wp_enqueue_script( 'stock_notify' );
 }


}

new NotifyProductActivity();
