
<?php
/**
 * Simple product add to cart
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/add-to-cart/simple.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 7.0.1
 */

defined( 'ABSPATH' ) || exit;

global $product;
$StockQ = $product->get_stock_quantity();
$checker = new mob_cheker;
$signle_cart_text = get_post_meta(get_the_ID(), 'prk_add_to_cart_label', true );
$general_cart_text = prk_option('prk_single_product_text_cart');
$opnened_miny_cart = prk_option('opnened_miny_cart');
if ($opnened_miny_cart) {
  $class_opened = "opnened_mcart";
}else {
  $class_opened = "";
}
 ?>

	<?php do_action( 'woocommerce_before_add_to_cart_form' ); ?>

	<form class="cart" action="<?php echo esc_url( apply_filters( 'woocommerce_add_to_cart_form_action', $product->get_permalink() ) ); ?>" method="post" enctype='multipart/form-data'>

	<?php do_action( 'woocommerce_before_add_to_cart_button' ); ?>

<?php if ( $product->is_purchasable() && $product->is_in_stock() ):?>

		<?php	do_action( 'woocommerce_before_add_to_cart_quantity' );

		woocommerce_quantity_input(
			array(
				'min_value'   => apply_filters( 'woocommerce_quantity_input_min', $product->get_min_purchase_quantity(), $product ),
				'max_value'   => apply_filters( 'woocommerce_quantity_input_max', $product->get_max_purchase_quantity(), $product ),
				'input_value' => isset( $_POST['quantity'] ) ? wc_stock_amount( wp_unslash( $_POST['quantity'] ) ) : $product->get_min_purchase_quantity(), // WPCS: CSRF ok, input var ok.
			)
		);
		do_action( 'woocommerce_after_add_to_cart_quantity' );?>

<?php endif;?>

<?php if ( $product->is_purchasable() && $product->is_in_stock() ) :?>

	<button type="submit" name="add-to-cart"

  value="<?php echo esc_attr( $product->get_id() ); ?>"
  class="single_add_to_cart_button button alt <?php echo $class_opened;  if ( $product->is_sold_individually( )|| ($StockQ==1) ){ echo 'maxw';};?>">

  <?php

     if ( ! empty($signle_cart_text) ) {

       echo esc_html( $signle_cart_text );

     }
     elseif( ! empty($general_cart_text) ) {

       echo esc_html( $general_cart_text );

     }
     else {

       echo esc_html( $product->single_add_to_cart_text() );

     }





  ?>

  </button>

<?php endif;?>

<?php do_action( 'woocommerce_after_add_to_cart_button' ); ?>

	</form>





	<?php do_action( 'woocommerce_after_add_to_cart_form' );?>
